PXRMSKIN ; SLC/PKR - Handle skin test findings. ;08/31/2004
 ;;2.0;CLINICAL REMINDERS;;Feb 04, 2005
 ;
 ;====================================================
EVALFI(DFN,DEFARR,ENODE,FIEVAL) ;Evaluate skin test findings.
 D EVALFI^PXRMINDX(DFN,.DEFARR,ENODE,.FIEVAL)
 Q
 ;
 ;====================================================
EVALPL(FINDPA,ENODE,TERMARR,PLIST) ;Evaluate skin test term findings
 ;for patient lists.
 D EVALPL^PXRMINDL(.FINDPA,ENODE,.TERMARR,PLIST)
 Q
 ;
 ;====================================================
EVALTERM(DFN,FINDPA,ENODE,TERMARR,TFIEVAL) ;Evaluate skin test terms.
 D EVALTERM^PXRMINDX(DFN,.FINDPA,ENODE,.TERMARR,.TFIEVAL)
 Q
 ;
 ;====================================================
GETDATA(DAS,FIEVT) ;Return data for a specified V Skin Test entry.
 ;DBIA #4250
 D VSKIN^PXPXRM(DAS,.FIEVT)
 Q
 ;
 ;====================================================
MHVOUT(INDENT,IFIEVAL,NLINES,TEXT) ;Produce the MHV output.
 N EM,FIEN,IND,JND,NAME,NOUT,PNAME,READING,RESULTS,TEMP,TEXTOUT,VDATE
 S FIEN=$P(IFIEVAL("FINDING"),";",1)
 S PNAME=$P(^AUTTSK(FIEN,0),U,1)
 S NAME="Skin Test: "_PNAME
 S IND=0
 F  S IND=+$O(IFIEVAL(IND)) Q:IND=0  D
 . S RESULTS=$G(IFIEVAL(IND,"RESULTS"))
 . I $L(RESULTS)>0 S RESULTS=" "_$$EXTERNAL^DILFD(9000010.12,.04,"",RESULTS,.EM)
 . S READING=$G(IFIEVAL(IND,"READING"))
 . I READING'="" S READING=" reading "_$$EXTERNAL^DILFD(9000010.12,.05,"",READING,.EM)
 . S VDATE=IFIEVAL(IND,"DATE")
 . S TEMP=NAME_RESULTS_READING_" ("_$$EDATE^PXRMDATE(VDATE)_")"
 . D FORMATS^PXRMTEXT(INDENT+2,PXRMRM,TEMP,.NOUT,.TEXTOUT)
 . F JND=1:1:NOUT S NLINES=NLINES+1,TEXT(NLINES)=TEXTOUT(JND)
 S NLINES=NLINES+1,TEXT(NLINES)=""
 Q
 ;
 ;====================================================
OUTPUT(INDENT,IFIEVAL,NLINES,TEXT) ;Produce the clinical
 ;maintenance output.
 N EM,FIEN,IND,JND,NOUT,PNAME,READING,RESULTS,TEMP,TEXTOUT,VDATE
 S FIEN=$P(IFIEVAL("FINDING"),";",1)
 S PNAME=$P(^AUTTSK(FIEN,0),U,1)
 S NLINES=NLINES+1
 S TEXT(NLINES)=$$INSCHR^PXRMEXLC(INDENT," ")_"Skin Test: "_PNAME
 S IND=0
 F  S IND=+$O(IFIEVAL(IND)) Q:IND=0  D
 . S VDATE=IFIEVAL(IND,"DATE")
 . S TEMP=$$EDATE^PXRMDATE(VDATE)
 . S RESULTS=$G(IFIEVAL(IND,"RESULTS"))
 . S READING=$G(IFIEVAL(IND,"READING"))
 . I RESULTS'="" D
 .. S TEMP=TEMP_" results - "
 .. S TEMP=TEMP_$$EXTERNAL^DILFD(9000010.12,.04,"",RESULTS,.EM)
 . I READING'="" D
 .. S TEMP=TEMP_" reading - "
 .. S TEMP=TEMP_$$EXTERNAL^DILFD(9000010.12,.05,"",READING,.EM)
 . D FORMATS^PXRMTEXT(INDENT+2,PXRMRM,TEMP,.NOUT,.TEXTOUT)
 . F JND=1:1:NOUT S NLINES=NLINES+1,TEXT(NLINES)=TEXTOUT(JND)
 . I IFIEVAL(IND,"COMMENTS")'="" D
 .. S TEMP="Comments: "_IFIEVAL(IND,"COMMENTS")
 .. D FORMATS^PXRMTEXT(INDENT+3,PXRMRM,TEMP,.NOUT,.TEXTOUT)
 .. F JND=1:1:NOUT S NLINES=NLINES+1,TEXT(NLINES)=TEXTOUT(JND)
 S NLINES=NLINES+1,TEXT(NLINES)=""
 Q
 ;
